import requests
import json
import datetime
from tqdm import tqdm

import requests_futures.sessions
import concurrent.futures

#-----------------------------------------------------------------------------------------------------------------
# Thanks to Michael Dorner, a fellow Phd student at BTH for providing me with the crawling script, which I later modified
#-----------------------------------------------------------------------------------------------------------------

#The code reads changes (Get changes/)from the selected url. For each OSS system, the url needs to be changed in 
# both the session.get calls. Also for openstack projects (neutron, nova) you need to set the "project_to_filter"
# value as well. For libreoffice, uncomment #changes_for_proj=changes line before the second session call. 


libreoffice_url = 'https://gerrit.libreoffice.org/changes/'
openstack_url = "https://review.openstack.org/changes/"
eclipse_url = "https://git.eclipse.org/r"
chromium_url = "https://chromium-review.googlesource.com"

retries = requests.packages.urllib3.util.retry.Retry(
    total=10, 
    backoff_factor=2, 
    status_forcelist=[401, 429, 500, 502, 503, 504]
)
http_adapter = requests.adapters.HTTPAdapter(max_retries=retries)
timeout = 10*60


def date_slices(from_date, to_date):
    for ordinal in range(from_date.toordinal(), to_date.toordinal()):
        start = datetime.datetime.fromordinal(ordinal)
        end = start + datetime.timedelta(days=1, milliseconds=-1)
        yield (str(start), str(end)[:-3])

first_change = datetime.datetime(year=2011, month=11, day=14)

days = list(date_slices(first_change, datetime.datetime.today()))

with requests_futures.sessions.FuturesSession(max_workers=4) as session:
    session.mount("https://", http_adapter)

    params = [()]

    changes_futures = [session.get(openstack_url, params={'q': 'after:"{}" AND until:"{}"'.format(start, end)}) for (start, end) in days]
    for future in tqdm(concurrent.futures.as_completed(changes_futures), total=len(changes_futures)):
        future.done()

changes = []
for f in changes_futures:
    r = json.loads(f.result().text[len("]}\\\'\n"):])
    assert isinstance(r, list), 'Parsed response is not a list'
    changes += r


#----- filtering the changes list based on project (only needed for open stak projects)
project_to_filter = "openstack/nova"
total_changes = len(changes)

num_of_changes_proj = 0
changes_for_proj = []

for rec in changes:
    jd = dict(rec)
    if(jd['project']== project_to_filter):
        num_of_changes_proj=num_of_changes_proj+1
        changes_for_proj.append(rec) 

#intermediate storage of output
#with open('/Users/uif_bth/Box Sync/My Documents/pythonCode/libre comments/Gerrit for Umar/filtered_changes.json', 'w') as json_file:
#    json.dump(changes_for_proj, json_file, indent=4)
print(num_of_changes_proj)

##--------------------------
#changes_for_proj=changes



with requests_futures.sessions.FuturesSession(max_workers=8) as session:
    session.mount("https://", http_adapter)

    comments_futures = [session.get(openstack_url+'{}/comments'.format(change['_number'])) for change in changes_for_proj]
    for future in tqdm(concurrent.futures.as_completed(comments_futures), total=len(comments_futures)):
        future.done()

comments = {}
for f in comments_futures:
    try:
        r = json.loads(f.result().text[len("]}\\\'\n"):])
    except:
        print(f.result().text)
    comments[f.result().url.split('/')[4]] = r

with open('/Users/uif_bth/Box Sync/My Documents/pythonCode/libre comments/Gerrit for Umar/rawdata.json', 'w') as json_file:
    json.dump(comments, json_file, indent=4)


#-----------------





#with requests_futures.sessions.FuturesSession(max_workers=4) as session:
#    session.mount("https://", http_adapter)

#    detail_changes_futures = [session.get('https://gerrit.libreoffice.org/changes/{}/detail'.format(change['id']), params=[('o', 'ALL_REVISIONS'), ('o', 'ALL_COMMITS'), ('o', 'ALL_FILES')]) for change in changes]
#    for future in tqdm(concurrent.futures.as_completed(detail_changes_futures), total=len(detail_changes_futures)):
#        future.done()

#detailed_changes = []
#for f in changes_futures:
#    r = json.loads(f.result().text[len("]}\\\'\n"):])
#    detailed_changes += [r]

#with open('changes.json', 'w') as json_file:
#    json.dump(detailed_changes, json_file)